#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7BrtMessage
	{
		#region Variables & Setup

		private const string CARRIAGE_RETURN = "\x0D";

		private static string _hl7Message;

		HL7BrtMessage _brtMessage;

		static Messages_HL7BrtMessage()
		{
			_hl7Message = string.Concat(
				"MSH^~|\\&^VBECS^VBECS^WBC^589^20080526032505-0500^^BRT~O32^VBECS8052603208125^T^2.5",
				CARRIAGE_RETURN,
				"MSA^AE^WBC200805261513234027",
				CARRIAGE_RETURN,
				"ERR^^^206~You locked this record in another area 05/22/2008 15:17.^E",
				CARRIAGE_RETURN );
		}

		[SetUp]
		public void SetUp()
		{
			_brtMessage = new HL7BrtMessage( _hl7Message );
		}

		#endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7BrtMessage brtMessage = new HL7BrtMessage( _hl7Message );
			//
			Assert.IsTrue( brtMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7BrtMessage brtMessage = new HL7BrtMessage( null );
			//
			Assert.IsTrue( brtMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _brtMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

		[Test]
		public void GetMessageControlID_Pass()
		{
			Assert.IsNotNull( _brtMessage.GetMessageControlID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _brtMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _brtMessage.IsResponseRequired() == false );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}

		#endregion

		#region Properties

		[Test]
		public void AcknowledgementCode_Pass()
		{
			Assert.IsNotNull( _brtMessage.AcknowledgementCode );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void AcknowledgementCode_Fail()
		{
		}

		[Test]
		public void ErrorCode_Pass()
		{
			Assert.IsNotNull( _brtMessage.ErrorCode );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ErrorCode_Fail()
		{
		}


		[Test]
		public void ErrorText_Pass()
		{
			Assert.IsNotNull( _brtMessage.ErrorText );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ErrorText_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.IsNotNull( _brtMessage.Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

		[Test]
		public void MessageControlID_Pass()
		{
			Assert.IsNotNull( _brtMessage.MessageControlID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageControlID_Fail()
		{
		}

		[Test]
		public void MessageType_Pass()
		{
			Assert.IsNotNull( _brtMessage.MessageType );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageType_Fail()
		{
		}

		[Test]
		public void MSH_Pass()
		{
			Assert.IsNotNull( _brtMessage.MSH );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSH_Fail()
		{
		}

		[Test]
		public void MSA_Pass()
		{
			Assert.IsNotNull( _brtMessage.MSA );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSA_Fail()
		{
		}

		[Test]
		public void ERR_Pass()
		{
			Assert.IsNotNull( _brtMessage.ERR );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ERR_Fail()
		{
		}
		
		#endregion
	}
}
#endif
